//	CDiskPas.h

#ifndef _H_CDiskPas
#define _H_CDiskPas

#include "CDisk.h"
#include "PasStructs.h"

typedef	OSErr	(*Pas_ForEachBitmapBlockCB)(
	CDiskPas		*thiz, 
	Pas_BlockNum	block, 
	Boolean			*free, 
	Boolean			*done, 
	void			*data);

class CDesktop;
class CDiskPas : public CDisk {

	public:	
	
	OSErr		IDiskPas(
		CDesktop		*desktop, 
		DiskImageRec	*imageRec
	);
	
	virtual	void			Dispose(void);

	OSErr			Pas_CacheDirectory(void);
	OSErr			Pas_FlushDirectory(void);

	virtual	Pas_DirEntry	*GetMyEntry(void);
	virtual	OSErr			BuildFileTypeMenu(void);
	virtual	short			MenuItemToFileType(short menuItem, ushort *auxType);
	virtual	char			*GetName(char *buf);
	virtual	void			SetName(char *buf);
	virtual	OSErr			SetGenericBlock(ushort blockNumS, Gen_Block *blockP);
	virtual	OSErr			GetGenericBlock(ushort blockNumS, Gen_Block **blockP);
	virtual	OSErr			GetBlock(Pas_BlockNum blockNum, Pas_Block **blockP);
	virtual	OSErr			SetBlock(void);
	virtual ADFS_IconType	GetIconType(void);
	virtual char			*GetDescription(char *buf);
	
	virtual	ulong			GetTotalBlocks(void);
	virtual	ulong			GetVolumeSize(void);
	
	virtual	void			SetTwirled(Boolean twirledB);
	virtual	Boolean			GetTwirled(void);

	virtual	DateTimeRec		*GetModifiedTime(DateTimeRec *dt);
	virtual	OSErr			NewDisk_Completion(ADFS_NewDiskCompletionRec *recP);
	
	OSErr			IsBlockFree(Pas_BlockNum curBlock, Boolean *isFreeB);

	OSErr			Pas_ForEachBitmapBlock(
		Pas_ForEachBitmapBlockCB	ForEachBitmapBlockUserCB, 
		void						*data);
	
	ulong					CalcBytesUsedByFile(ulong fileSize);
	ulong					GetVolumeMaxFileSize(ushort pro_fileTypeS);

	virtual ulong			GetVolumeBytesUsed(void);
	virtual OSErr			GetFreeBlock(Pas_BlockNum *freeBlock);
	virtual OSErr			ZeroUnused(void);

	OSErr 	Pas_CB_AscendingDirSort(
		CFilePas 	*a, 
		CFilePas 	*b, 
		int			*resultS);

	virtual	OSErr			Optimize(void);

	OSErr		GetUnAllocBlocks(
		Boolean			getAsBlocksB,
		Pas_BlockNum	*maxEmptyS, 
		Pas_BlockNum	*blockListA);

	OSErr		GetEntryAlloc(
		Boolean			getAsBlocksB, 
		Gen_EntryAlloc	**sectorListH);

	ushort		GetSectorsPerBlock(void);
	ushort		GetBlocksPerTrack(void);

	/***************************************************/
	//	instance vars
	Pas_Block		*i_blockBuf;
	Pas_BlockNum	i_recentBlockNum;		//	from most recent GetSector

	union {
		Pas_Directory	index;
		Pas_Block		blocks[Pas_kDirEndBlockPlusOne - Pas_kDirStartBlock];
	} i_directory;
	
	private:
	typedef CDisk _inherited;
};

#endif
